		save
	if DontListIncls
		listing off
	endif

;********************************************************************
;
; This file contains definitions for both the code inside the Z8
; 341-0339-A and the external EPROM 342-0343-B.
;
; At Apple, both the intenal and external ROM code were generated
; from a common source, but here we have two separate assembler
; files.
;
; 2013-05-02 PS
; last changes 2013-08-07 PS
;
;********************************************************************

Stack_Top 	EQU 080h		; Register 07Fh +1



;********************************************************************
;
; Hardware
;
;********************************************************************
;
;	I/O Port	Use
;	--------	---
;	   0		Bit 0: Adr8
;	{Output}	Bit 1: Adr9
;			Bit 2: Adr10
;			Bit 3: Adr11
;			Bit 4: Hs0
;			Bit 5: Hs1
;			Bit 6: /RWI
;			Bit 7:
;
;	   1 		Bit 0: Adr0 / Apple_Bus0
;    {Input/Output}	Bit 1: Adr1 / Apple_Bus1
;			Bit 2: Adr2 / Apple_Bus2
;			Bit 3: Adr3 / Apple_Bus3
;			Bit 4: Adr4 / Apple_Bus4
;			Bit 5: Adr5 / Apple_Bus5
;			Bit 6: Adr6 / Apple_Bus6
;			Bit 7: Adr7 / Apple_Bus7
;
;	   2 		Bit 0: Servo_Reset-
;    {Input/Output}	Bit 1:
;			Bit 2:
;			Bit 3:
;			Bit 4:
;			Bit 5:
;			Bit 6: SioRdy {Input}
;			Bit 7:
;
;	   3		Bit 0: SioDataIn {Input}
;    {Input/Output}	Bit 1: Sector {Input}
;			Bit 2: Index {Input}
;			Bit 3:
;			Bit 4:
;			Bit 5:
;			Bit 6:
;			Bit 7: SioDataOut
;

; Port 0 Defs:
Hs0		EQU 010h	; head select 0
Hs1		EQU 020h	; head select 1
RWI 		EQU 040h	; Reduced Write Current {active low}

; Port 2 Defs:
ServoRst 	EQU 000h	; Servo Reset {active low}
Not_ServoRst 	EQU 001h
SioRdy 		EQU 040h	; Servo's Sio is ready {active hi}

; Port 3 Defs:
SectorMark 	EQU 002h	; Sector Mark from drive {active hi}
IndexMark 	EQU 004h	; Index Mark from drive {active hi}

; Controller Status Port
;??? StatusPort	EQU 01F00h
CrcErrL		EQU 080h	; status bit 7: Crc Error {active lo}
WrtNvldL	EQU 040h	; status bit 6: Write Not Valid {active lo}
ServoRdy	EQU 020h	; status bit 5: Servo Ready {active hi}
ServoErr	EQU 010h	; status bit 4: Servo Error {active hi}
Ymask		EQU 00Fh	; mask for status bits 0:3: state
Norm_State	EQU 002h	;   normal end state for Read, Write, ReadHdr
NormFmt_State	EQU 00Ah	;   normal end state for Format
NoHdr_State	EQU 000h	;   last state if no matching header found
Start_State	EQU 000h	;   beginning state machine state

Eprom2 		EQU 02h


;********************************************************************
;
; Registers
;
;********************************************************************

; working register sets R0:15 (select by setting RP)
Wrk_Sys 	EQU 010h	; Working regs set 1 = System
Wrk_Scr 	EQU 040h	; Working regs set 4 = Scratch set
Wrk_Cntrl	EQU 0F0h	; Working regs set F = control set

Excpt_Stat 	EQU 032h	; exception status register
Recovery 	EQU 080h	;   global recovery bit {active hi}
SprTbl_Warn 	EQU 040h	;   spare table is almost full
Buf_Damage 	EQU 020h	;   StMach entry buffer is not zero  ; ???
PwrRst	 	EQU 010h	;   Widget was power reset
NZero_Stat 	EQU 008h	;   last system status was non-zero
UseECC		EQU 004h	;   1 =  do ECC check, 0 = return checkbytes as-is
;???		EQU 002h
LedStat 	EQU 001h	;   state of LED on controller

SlfTst_Result 	EQU 033h	; results of self test
Ram_Fail 	EQU 080h	;   writeable memory failure
Eprom_Fail 	EQU 040h	;   Eprom checkbyte mismatch
Disk_Speed 	EQU 020h	;   Disk not up to speed
Servo_Fail 	EQU 010h	;   Servo is not healthy
Sector_Cnt 	EQU 008h	;   Not enough sectors!
State_Fail 	EQU 004h	;   State machine not healthy
Rw_Fail		EQU 002h	;   can't read/write!
No_SprTbl	EQU 001h	;   No Spare Table found!

RWStat 		EQU 034h	; status of last read / write operation
RdError 	EQU 080h
RdSrvoErr 	EQU 040h
RdNoHdrFnd 	EQU 020h
RdCrcErr 	EQU 010h
RdSMErr		EQU 008h
RdHError 	EQU 080h
RdHSrvoErr 	EQU 040h
WrError 	EQU 080h
WrSrvoErr	EQU 040h
WrNoHdrFnd 	EQU 020h
WrSMErr		EQU 008h
FmtError 	EQU 080h
FmtSrvoErr 	EQU 040h
FmtSuccess 	EQU 020h

DiskStat	EQU 035h	; current state of some disk params
On_Track	EQU 080h	;   software on-track flag
RdHdrRecal	EQU 040h	;   read the header after a recal operation
Wr_Op		EQU 020h	;   current access is for a write
Parked		EQU 010h	;   heads are currenly parked
Offset_On 	EQU 008h	;   Auto-Ofset is currently on
User_Type 	EQU 004h	;   type of element is User data block
SeekComplete	EQU 002h	;   head/arm is not in motion
Offset_Set	EQU 001h	;   track offset has been applied

; ???		EQU 036h	; used as temp

Cur_Cyl 	EQU 038h
Cylinder	EQU 03Ah
Head		EQU 03Ch
Sector		EQU 03Dh

;???		EQU 03Eh	;
S_Block		EQU 040h	;   this block is a spare block
B_Block		EQU 020h	;   this block is a bad block
;		EQU 010h	;
;		EQU 008h	;
;		EQU 004h	;
;		EQU 002h	;
HDA_Type	EQU 001h	;   0 = Nisha (610/2), 1 = Rodime (305/4) mechanism


ScrReg0 	EQU 040h	; Scratch register 0
ScrReg1    	EQU 041h	; Scratch register 1
ScrReg2     	EQU 042h	; Scratch register 2
ScrReg3     	EQU 043h	; Scratch register 3
ScrReg4     	EQU 044h	; Scratch register 4
ScrReg5     	EQU 045h	; Scratch register 5
ScrReg6     	EQU 046h	; Scratch register 6
ScrReg7     	EQU 047h	; Scratch register 7
ScrReg8     	EQU 048h	; Scratch register 8
ScrReg9     	EQU 049h	; Scratch register 9
ScrRegA     	EQU 04Ah	; Scratch register A
ScrRegB     	EQU 04Bh	; Scratch register B
ScrRegC     	EQU 04Ch	; Scratch register C
ScrRegD     	EQU 04Dh	; Scratch register D
ScrRegE     	EQU 04Eh	; Scratch register E
ScrRegF     	EQU 04Fh	; Scratch register F

; ???		EQU 050h
;		EQU 010h	; cleared after command received, set if system command
; ???		EQU 051h
; ???		EQU 053h
; ???		EQU 054h

;		EQU 05Dh
Status0		EQU 05Fh
Status1		EQU 05Eh

;		EQU 072h

;********************************************************************
;
;    Constant Definitions
;
;********************************************************************

BlockLength 	EQU 524+2+6 	; Length = Data + CRC + ECC

HiMaxLogical 	EQU 000h	; highest user block =009834h
MidMaxLogical 	EQU 098h
LoMaxLogical 	EQU 034h
NbrSctrs 	EQU 32		; number of sectors = 32
Tst_Sctr 	EQU 000h

; Rodime RO552 HDA mechanism
NbrHds_A	EQU 4		; number of heads = 4
NbrTracks_A 	EQU 305		; number of tracks = 305
Tst_HiCyl_A 	EQU 001h	; Cyl, Head, and sector of R/W test area
Tst_LoCyl_A	EQU 031h
Tst_Head_A 	EQU 003h
Init_HiCyl_A 	EQU 000h	; initial setting for data cylinder
Init_LoCyl_A	EQU 000h
ParkCyl_A	EQU 00130h

; Nisha HDA mechanism
NbrHds_B	EQU 2		; number of heads = 2
NbrTracks_B 	EQU 610		; number of tracks = 610
Tst_HiCyl_B 	EQU 002h
Tst_LoCyl_B 	EQU 067h
Tst_Head_B 	EQU 001h
HiMaxCyl 	EQU 002h	; highest cylinder = 616
LoMaxCyl 	EQU 068h
Init_HiCyl_B 	EQU 002h	; initial setting for data cylinder
Init_LoCyl_B	EQU 030h
ParkCyl_B 	EQU 0026Ch	; cylinder to park heads at

HiSpr0 		EQU 000h	; logical block of Spr(0)
MidSpr0 	EQU 032h
LoSpr0 		EQU 0ABh
HiSpr1		EQU 000h	; logical block of Spr(1)
MidSpr1 	EQU 065h
LoSpr1 		EQU 053h

SprThresh 	EQU 3 		; this many CRC errors to be candidate for sparing


; >>> "SpareTable" array element flags (byte 0)
Nil 		EQU 080h	; Nil Ptr
Used  		EQU 040h	; Spare Block in table is used
Useable  	EQU 020h	; Spare Block in table is useable (not a bad block itself)
Spare 		EQU 010h	; element is a true spare
BadBlock 	EQU 000h	; element is a bad block
SprTbl_Type 	EQU 008h	; type of element is spare table
ID_Type 	EQU 004h	; type of element is ID block
UserBlk_Type 	EQU 002h	; type of element is User data block

Found 		EQU 001h	; Block was found in spare table

TestBitMap 	EQU 080h	; check bit map location for 0 or 1
SetBitMap 	EQU 040h	; set a bit map location
ClearBitMap	EQU 020h	; clear a bit map location

Inc_SprCnt 	EQU 000h
Inc_BadCnt 	EQU 001h
Dec_BadCnt 	EQU 002h

NbrZones 	EQU 16			; 16 zones for manual offset
ZoneShift 	EQU 5			; use this shift value to divide
MinOffset 	EQU 10			; manual offset only if greater than 10


; >>> Data Exception Error Codes
Error 		EQU 080h
Ex_Undetermined EQU 000h	; Undetermined error (recovery off?)
Ex_SprBlock 	EQU 002h	; Spare this block!
Ex_BadBlock 	EQU 004h	; make this block a bad block
Ex_ReadErr 	EQU 006h	; non-catastophic error during read
Ex_HdrBad 	EQU 008h	; make this block bad because no header
Ex_HdrSpr 	EQU 00Ah	; spare this block because no header

Ex_Case_Max 	EQU 00Ah	; maximum case values


; >>> System Status Definitions
; Byte 0
;??? Bad_55 		EQU 080h	; Status: Other than 55 response from host
;??? WrBuf_OR 	EQU 040h	; Status: Write Buffer Overflow
;??? Stat_Rd_Err	EQU 008h	; Status: Read Error
;??? Stat_No_Hdr 	EQU 004h	; Status: No Header Found
;??? Stat_Srvo 	EQU 002h	; Status: Unrecoverable Servo Error
;??? Op_Failed 	EQU 001h	; Status: Operation Failed

; Byte 1
SprBlk_Hard 	EQU 040h	; Status: no room left in spare table
;??? SprBlk_Warn 	EQU 020h	; Status: 5 or less spare blocks available
;??? Stat_SlfTst 	EQU 008h	; Status: Abort caused by self test failure
Stat_Spare 	EQU 004h	; Status: Sparing has occured
Stat_Seek 	EQU 002h	; Status: Seek to wrong track
;??? Stat_Abort 	EQU 001h	; Status: Controller aborted

; Byte2
;??? Power_Reset 	EQU 080h	; Widget was power reset
;??? Illegal_Block 	EQU 040h	; Status: Block number out of bounds

; Byte3
EccStat 	EQU 080h	; read error detected by ecc
CrcStat 	EQU 040h	; read error detected by crc
Hdr_MisMatch	EQU 020h	; timeout waiting for header


S_Store 	EQU 000h	; comm error in Servo Store
S_Load 		EQU 001h	; comm error in Servo Load


; >>> Abort codes
;  8	not used
;  9	command rejected because selftest failed
; 10	forced abort (Cmd 14)
; 11	servo error during RW_Common
; 12	error from CnvrtLogical during SpareBlock
; 13	GetNewSpare, spare table full
; 14	DeleteSpare, no spare table found
; 15	data exception handler gave up (error code was odd)
; 18	Cmd 7 Send Servo Command, cmd was "get status"
; 19	Cmd 9 Send Restore, argument was not 40h or 70h
; 20	Cmd 12 Write Spare Table, password mismatch
; 21	Format, password mismatch
; 24	Cmd 0 Sys_Read, block count was zero
; 26	state machine error during RW_Common
; 28	Cmd 0 Sys_Read, mutiple block read causes LBA overflow
; 30	Load_SprTbl, no spare table found
; 31	UpDate_SprTbl, CnvrtLogical failed
; 32	UpDate_SprTbl, seek failed and no recovery set
; 33	SpareCount received illegal command
; 34	Seek failed
; 35	ServoCmnd failed
; 36	ServoStatus failed
; 39	ResetServo failed
; 49	RwTest failed
; 50	CnvrtLogical, HeadPtr out of range
; 53	GetNewSpare, LBA out of range
; 55	not used
; 56	Cmd 1
; 57	FormatTrack, selftest was not passed
; 58	FormatTrack
; 59	SctrCount, sector count mismatch
; 60	SctrCount, index mark timeout
; 61	Cmd 0/1/FormatTrack  5Dh mismatched 1020h
; SlfTst_Result	S_Blk_New in SpareBlock

;********************************************************************
;
; External Ram Stuff
;
;********************************************************************

		ORG 01000h
ReadArray
RSctrGap  	DB 10 dup(?)
RHdrGap  	DB 1 dup(?)
RHeader  	DB 6 dup(?)
RDataGap  	DB 7 dup(?)
RDummy  	DB 1 dup(?)
RBuffer1  	DB 532 dup(?)		; 1019h
RBuf1Ecc  	DB 6 dup(?)		; 122Dh
REndGap  	DB 1 dup(?)		; 1233h
RBuf1Pw  	DB 4 dup(?)

		ORG 01000h
ReadHdrArray
RHSctrGap	DB 10 dup(?)
RHHdrGap 	DB 2 dup(?)
RHHeader 	DB 6 dup(?)
RHDataGap 	DB 6 dup(?)
RHDummy		DB 1 dup(?)
RHBuffer1 	DB 532 dup(?)
RHBuf1Ecc 	DB 6 dup(?)
RHEndGap 	DB 1 dup(?)
RHBuf1Pw 	DB 4 dup(?)

RdH_Stat_Array 	EQU RHHeader -4

		ORG 01000h
WriteArray
WSctrGap	DB 10 dup(?)
WHdrGap 	DB 1 dup(?)
WHeader 	DB 6 dup(?)
WDataGap 	DB 14 dup(?)
WDataSync 	DB 2 dup(?)
WBuffer1 	DB 532 dup(?)		; 1021h
WBuf1Ecc 	DB 6 dup(?)
WEndGap 	DB 2 dup(?)		; 123Bh
WBuf1Pw 	DB 4 dup(?)

		ORG 01000h +32
FormatArray
FSctrGap	DB 10 dup(?)		; 1020h
FHdrGap 	DB 16 dup(?)
FHdrSync 	DB 2 dup(?)
FHeader 	DB 6 dup(?)
FDataGap 	DB 14 dup(?)
FDataSync 	DB 2 dup(?)
FBuffer1 	DB 532 dup(?)		; 1052h
FBuf1Ecc 	DB 6 dup(?)
FEndGap 	DB 2 dup(?)

	org $-8		; ??? buffer structures ???
Buf2Array				; 1266h
BufDummy 	DB 1 dup(?)
Buffer2 	DB 532 dup(?)
Buf2Crc 	DB 2 dup(?)
Buf2Ecc 	DB 6 dup(?)
Buf2Pw2 	DB 4 dup(?)


	org 0123Fh
Abort_Stat 	DB 16 dup(?)		; last abort info
	org 0124Fh
LastSeek_Stat	DB 4 dup(?)		; last seek address

	org 0147Bh
;		DB 4 dup(?)
	org 0147Fh
;		DB 1 dup(?)
	org 01480h
LogicalBlock	DB 3 dup(?)		; 1480h  current logical block
HostCmndBuf	DB 8 dup(?)		; 1483h  Host Command Buffer
SrvoCmndBuf 	DB 5 dup(?)		; Servo Command Buffer
S_Cmnd_Len 	EQU 5			; Length of ServoCmndBuffer
SStatus0	DB 5 dup(?)		; Servo Status


SpareArray
SparePw1	DB 4 dup(?)		; 1495h  fence (F0 78 3C 1E)
SpareTmStmp 	DB 4 dup(?)		; run number (incremented each time the spare table is written)
FmtOffset	DB 1 dup(?)		; format offset, default 0
FmtlntrL 	DB 1 dup(?)		; format (first) interleave set, default 1
SegPtrArray 	DB 64 dup(?)		; 149Fh pointer (HeadPtr) to spares list for each LBA MSB
					;  Nil (080h) means none of these 256 blocks has been relocated
SprCount	DB 1 dup(?)		; 14DFh  number of spares used
BadCount 	DB 1 dup(?)		; 14E0h  number of bad blocks pending
SpareBitMap 	DB 10 dup(?)		; bit set for each spare in use
SpareTable 	DB 304 dup(?)
Map_Table	DB NbrSctrs dup(?)	; 161Bh (second) interleave map
SpareCheck	DB 2 dup(?)		; checksum from fence to end of heap
SparePw2	DB 4 dup(?)		; fence (F0 78 3C 1E)

SpareLength 	EQU $-SpareArray
SpareEnd 	DB BlockLength+1-SpareLength dup(?)
Zone_Table	EQU SpareEnd

StatusArray 	EQU RBuffer1 -4
Cmnd_Ptr 	EQU WBuffer1 -6		; host passes command here!
BlockID 	EQU 512 		; offset of controller useable space



;********************************************************************
;
; Servo Definitions
;
;********************************************************************
;
; Nisha servo runs at 58.59kbps (7,5MHz / 128)

S_Cmnd_Byte 	EQU 000h	; Servo Command Byte
S_Diff_Byte 	EQU 001h	; Servo Lo Difference Byte
S_Off_Byte 	EQU 002h	; Servo Offset Byte
S_Stat_Byte 	EQU 003h	; Servo Status Byte

; BYTE 0  Command, Direction, and Hi Difference Byte
ReadStatus 	EQU 000h	; Servo Command: Read Status
Offset 		EQU 010h	; Servo Command: Offset, Track Following
Diagnostic 	EQU 020h	; Servo Command: Diagnostic
DataRecal 	EQU 040h	; Servo Command: Recalibrate heads, Data
FrmtRecal 	EQU 070h	; Servo Command: Recalibrate heads, Format
Access 		EQU 080h	; Servo Command: Access only
Access_Offset 	EQU 090h	; Servo Command: Seek with Offset
Home	 	EQU 0C0h	; Servo Command: Home the heads
;
Hd_Dir_Rev  	EQU 000h	; Direction: Reverse
Hd_Dir_Frwd  	EQU 008h	; Direction: Forward
;  Bits 0:1  Magnitude: Hi Difference

;  BYTE 1  Magnitude: Lo Difference

;  BYTE 2  Offset Byte
Off_Dir_Rev	EQU 000h	; Offset Direction Reverse
Off_Dir_Frwd 	EQU 080h	; Offset Direction Forward
Off_Auto 	EQU 040h	; Auto-Offset On
Ld_Off_Val 	EQU 020h	; Load Offset Value from DAC on Servo
Dir_Frwd	EQU 020h	; offset sign bit forward
;  Off_Val 	EQU 01Fh	; 5-bit value Loaded/Stored into DAC

;  BYTE 3  Status Byte
S_Stat_O 	EQU 000h	; Servo Status 0
S_Stat_1 	EQU 001h	; Servo Status 1
S_Stat_2 	EQU 002h	; Servo Status 2
S_Stat_3 	EQU 003h	; Servo Status 3
S_Stat_4 	EQU 004h	; Servo Status 4
S_Stat_5 	EQU 005h	; Servo Status 5
S_Stat_6 	EQU 006h	; Servo Status 6
S_Stat_7 	EQU 007h	; Servo Status 7

S_Norm_Status 	EQU S_Stat_1 	; Normal Servo Status


;********************************************************************
;
; Z8 Internals
;
;********************************************************************

; Control Register 240 ($FO): Serial I/O register (SIO)
;              {Read: Receive Data}
;              {Write: Transmit Data}

; Control Register 241 ($F1): Timer Mode Register (TMR)
;   Tout Modes: Bits 7 and 6
T0_Out 		EQU 040h 	; Port 3, bit 6 gets timer 0 out
T1_Out 		EQU 080h 	; Port 3, bit 6 gets timer 1 out
Int_Out 	EQU 0C0h 	; Port 3, bit 6 gets system clock
; Tin Mode: Bits 5 and 4
Ext_Clk 	EQU 000h 	; use external clock on timer
Gate_Clk 	EQU 010h 	; use internal clock on timer
Non_Retrig 	EQU 020h 	; load T1 after a high-low trans
Retrig 		EQU 030h 	; like Non-Retrig, but load on all trans.
T1_CntEn 	EQU 008h 	; enable T1 counting operations
T1_CntDis 	EQU 000h
T1_Load 	EQU 004h 	; Load T1
T0_CntEn 	EQU 002h 	; enable T0 counting operations
T0_CntDis	EQU 000h
T0_Load		EQU 001h 	; Load T0

; Control Register 242 ($F2): Counter/Timer Register (T1)
;         {Write: Initial Value}
;         {Read: Current Count Value}

; Control Register 243 ($F3): T1 Prescaler Load Register (PRE1)
Single_Pass 	EQU 000h
Mod_n 		EQU 001h
T1_Int_Clk 	EQU 002h
T1_Ext_CIk 	EQU 000h
; Bits 7:2 are used to provide a 6-bit binary Prescale Value

; Control Register 244 ($F4): Counter/Timer Register (T0)
;         {Write: Initial Value}
;         {Read: Current Count Value}

; Control Register 245 ($F5): T0 Prescaler Load Register (PRE0)
;         {Same as Pre1, but no external clock}

; Control Register 246 ($F6): Port 2 Mode (P2M)
;  When a bit of P2M is set, the corresponding bit in Port 2 is defined
;  as an input, if reset then the corresponding bit for Port 2 is
;  defined as an output.

; Control Register 247 ($F7): Port 3 Mode (P3M)
Open_Drain 	EQU 000h
Totem_Pol 	EQU 001h
B2_5_Io 	EQU 000h	; Bit 2=input, Bit 5=output
B2_5_Hs 	EQU 004h 	; Bit 2=DAV0-, Bit 5=RDY0-
B3_4_Io 	EQU 000h	; Bit 3=input, Bit 4=output
B3_4_Idm 	EQU 010h 	; Bit 3=input, Bit 4=DM-
B3_4_Hs 	EQU 018h 	; Bit 3=DAV1-, Bit 4=RDY1-
B1_6_Io 	EQU 000h 	; Bit 1=Tin, Bit 6=Tout
B1_6_Hs 	EQU 020h 	; Bit 1=DAV2-, Bit 6=RDY2-_
B0_7_Io 	EQU 000h 	; Bit O=input; Bit 7=output
B0_7_Ser 	EQU 040h 	; Bit O=Sio in, Bit 7=Sio out
Par_On 		EQU 080h 	; Parity On
Par_Off 	EQU 000h 	; Parity Off

; Control Register 248 ($F8): Port 0 and 1 Mode (P01M)
P0_03_Out 	EQU 000h 	; select Port 0, bits 0:3 as outputs
P0_03_In 	EQU 001h 	; select Port 1, bits 0:3 as inputs
P0_03_Adr 	EQU 002h 	; select PO, bits 0:3 as adr bits 8:11
Stack_Ext 	EQU 000h 	; select external stack
Stack_In 	EQU 004h 	; select internal slack
P1_Out 		EQU 000h 	; select Port 1 as outputs
P1_In 		EQU 008h 	; select Port 1 as inputs
P1_Adr 		EQU 010h 	; select Port 1 as adr/data bits 0:7
P1_Tri 		EQU 018h 	; put port 1 into Tri-State
Mem_Ext 	EQU 020h 	; extended memory timing
Mem_Norm 	EQU 000h 	; normal memory timing
P0_47_Out 	EQU 000h 	; select Port 0, bits 4:7 as outputs
P0_47_In 	EQU 040h 	; select Port 0, bits 4:7 as inputs
P0_47_Adr 	EQU 080h 	; select PO, bits 4:7 as adr bits 12:15

; Control Register 249 ($F9): Interrupt Priority Register (IPR)
;              {To Be Established}

; Control Register 250 ($FA): Interrupt Request Register (IRQ)
; IRQ Definitions
Timer1		EQU 20h 	; Timer 1 interrupt
Timer0		EQU 10h 	; Timer 0 interrupt
Serial_Out	EQU 10h 	; Sio transmitter ready
Serial_In	EQU 08h 	; Sio receiver ready
Irq_Sector	EQU 04h 	; Negative edge on sector mark
Irq_SecDn	EQU 02h
Irq_Index	EQU 01h 	; Negative edge on index mark


		restore


